;*
;* JAVA I/O FOR 6502
;*
	.INCLUDE	"global.inc"
;*
;* MAX NUMBER OF OPEN FILES
;*
MAX_FILES	EQU	1
;*
;* HANDY ROM ROUTINES
;*
ROM_MONITOR	EQU	$FF65
ROM_HOME	EQU	$FC58
ROM_BELL	EQU	$FF3A
ROM_COUT	EQU	$FDED
ROM_CROUT	EQU	$FD8E
ROM_CROUT1	EQU	$FD8B
ROM_PRBLNK	EQU	$F948
ROM_PRBL2	EQU	$F94A
ROM_PRBYTE	EQU	$FDDA
ROM_PRNTAX	EQU	$F941
ROM_GETLN	EQU	$FD6A

	.IMPORT	HMEM_ALLOC,HMEM_ALLOC_FIXED,HMEM_FREE,HMEM_PTR
	.IMPORT	THREAD_YIELD,THREAD_NOTIMEOUT,THREAD_NOTIFYIO,THREAD_WAITIO,SYSTEM_TIC,CURRENT_THREAD
	.IMPORT	THROW_IOEXCPTN,THROW_INTERNALERR,THREAD_TRACE
	.EXPORT	IO_INIT,HOME,GETLN,PRNTAX,CROUT,PRBYTE,COUT
	.EXPORT	PUTS
	.EXPORT	PUTSLN
	.EXPORT	PRSTR,PRSTRLN,PRHSTR,PRHSTRLN
	.EXPORT	KBWAIT
	.EXPORT	PREFIX_GET
	.EXPORT	FILE_OPEN,FILE_SETBUFFER,FILE_READ,FILE_CLOSE

	.SEGMENT "INIT"
IO_INIT:	LDA	#<SW_TIMER		; CREATE EXTERNAL LINKEAGE TO YIELD AT $300
	STA	LINK_YIELD
	LDA	#>SW_TIMER
	STA	LINK_YIELD+1
	LDA	#<SET_HW_TIMER
	STA	LINK_HWTIMER
	LDA	#>SET_HW_TIMER
	STA	LINK_HWTIMER+1
	LDA	#<SET_SLOT_HANDLER
	STA	LINK_SLOTIRQ
	LDA	#>SET_SLOT_HANDLER
	STA	LINK_SLOTIRQ
	LDA	#<PRODOS_MLI
	STA	LINK_PRODOS
	LDA	#>PRODOS_MLI
	STA	LINK_PRODOS+1
	LDA	#<PRHSTR
	STA	LINK_SCRPRT
	LDA	#>PRHSTR
	STA	LINK_SCRPRT+1
	LDA	#<PRHSTRLN
	STA	LINK_SCRPRTLN
	LDA	#>PRHSTRLN
	STA	LINK_SCRPRTLN+1
	LDA	#<KEYBD_READ
	STA	LINK_KBREAD
	LDA	#>KEYBD_READ
	STA	LINK_KBREAD+1
	LDA	#$00
	STA	TYPEBUFFLEN
	LDA	#<KEYBD_IRQ		; SET KEYBOARD IRQ HANDLER ON SLOT 3
	LDX	#>KEYBD_IRQ
	LDY	#$03
	JSR	SET_SLOT_HANDLER
	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$40		; OPEN FILE
	.ADDR	ALLOCINTPARMS
.IFDEF	DEBUG	
	BCC	:+
	JSR	PUTSLN
	.ASCIIZ	"FAILED TO ALLOCATE INTERRUPT"
:
.ENDIF
	JMP	SETLCBNK2
ALLOCINTPARMS:	.BYTE	$02
	.BYTE	$00		; INT NUM
	.ADDR	IO_INTERRUPT		; INT CODE
	
	.CODE
;*
;* WRAPPERS FOR ROM ROUTINES
;*
GETLN:	BIT	ROMIN
	JSR	ROM_GETLN
	JMP	SETLCBNK2
HOME:	BIT	ROMIN
	JSR	ROM_HOME
	JMP	SETLCBNK2
PRNTAX:	BIT	ROMIN
	JSR	ROM_PRNTAX
	JMP	SETLCBNK2
PRBYTE:	BIT	ROMIN
	JSR	ROM_PRBYTE
	JMP	SETLCBNK2
CROUT:	LDA	#$0D
COUT:	BIT	ROMIN
	ORA	#$80
	JSR	ROM_COUT
SETLCBNK2:	BIT	LCBNK2
	BIT	LCBNK2
	RTS
;
; PRINT ASCIIZ STRING FOLLOWING JSR PUTS
;
PUTSLN:	LDX	#$0D
	BNE	PUTSIT
PUTS:	LDX	#$00
PUTSIT:	PLA
	STA	TMP
	PLA
	STA	TMP+1
	LDY	#$00
PUTS_LP:	INC	TMP
	BNE	:+
	INC	TMP+1
:	LDA	(TMP),Y
	BEQ	PUTS_EXIT
	JSR	COUT
	JMP	PUTS_LP
PUTS_EXIT:	LDA	TMP+1
	PHA
	LDA	TMP
	PHA
	TXA
	BNE	COUT
	RTS
;
; PRINT STRING IN AX
;
PRHSTR:	JSR	HMEM_PTR
PRSTR:	STA	TMP
	STX	TMP+1
	LDY	#$00
	LDA	(TMP),Y
	BEQ	:+
	TAX
	INY
PRSTR_LP:	LDA	(TMP),Y
	JSR	COUT
	INY
	DEX
	BNE	PRSTR_LP
:	RTS
PRHSTRLN:	JSR	HMEM_PTR
PRSTRLN:	JSR	PRSTR
	JSR	CROUT
	RTS
;
; WAIT FOR KEYPRESS
;
KBWAIT:	LDA	KEYBD
	BPL	KBWAIT
	LDA	CLRKBD
	RTS
;*
;* I/O INTERRUPT ROUTINE
;*
IO_INTERRUPT:	CLD
	LDY	#$00
FNDIRQPROC:	LDA	IRQ_PROCH,Y
	BEQ	NXTIRQPROC
	STA	IRQ_PROC+1
	LDA	IRQ_PROCL,Y
	STA	IRQ_PROC
	STY	IRQ_SLOT
	INY
	JSR	CALLIRQPROC
	LDY	IRQ_SLOT
	BCC	IRQHANDLED
NXTIRQPROC:	INY
	CPY	#$07
	BCC	FNDIRQPROC
	LDA	TIMER_PROC+1
	BNE	:+
	RTS			; INTERRUPT NOT HANDLED
:	STA	IRQ_PROC+1		; TRY TIMER PROC IF INSTALLED
	LDA	TIMER_PROC
	STA	IRQ_PROC
CALLIRQPROC:	JMP	(IRQ_PROC)
IRQHANDLED:	INY
	JSR	THREAD_NOTIFYIO
	CLC
	RTS			; RETURN TO PRODOS HANDLER
;
; INSTALL IRQ HANDLER FOR SLOT
; ENTRY: AX = IRQ HANDLER ROUTINE ADDRESS
;         Y = SLOT
;
SET_SLOT_HANDLER: STA	IRQ_PROCL-1,Y
	TXA
	STA	IRQ_PROCH-1,Y
	RTS
;
; SET HW TIMER, REMOVE SOFTWARE TIMER
; ENTRY: AX = TIMER HANDLER ROTUINE ADDRESS
;
SET_HW_TIMER:	STA	TIMER_PROC
	STX	TIMER_PROC+1
	LDA	#<CHK_KEYBD		; CREATE EXTERNAL LINKEAGE TO YIELD AT $300
	STA	LINK_YIELD
	LDA	#>CHK_KEYBD
	STA	LINK_YIELD+1
	RTS
;
; SOFTWARE IMPLEMENTED (FAKED) INTERRUPT ROUTINES
;
SW_TIMER:	LDX	#$00
	LDA	#$00
	SEC
	SBC	OPCNT
	JSR	SYSTEM_TIC		; INCREMENT SYSTEM TICS BASED ON OPCNT
CHK_KEYBD:	LDA	KEYBD
	BMI	FAKEKEYBDIRQ
	JMP	THREAD_YIELD
FAKEKEYBDIRQ:
.IFDEF	DEBUG_BREAK
	CMP	#$83		; CHECK FOR CTRL-C
	BNE	NOBREAK
	BIT	CLRKBD
	LDA	#$4C
	STA	$03F8
	LDA	#<BREAKOUT
	STA	$03F9
	LDA	#>BREAKOUT
	STA	$03FA
	BIT	$C054		; SET TEXT MODE
	BIT	$C051
	JSR	HOME
	JSR	THREAD_TRACE
	BIT	ROMIN
	JMP	$FF65
BREAKOUT:	PLA			; REMOVE RETURN ADDRESS
	PLA
	BIT	CLRKBD
	BIT	LCBNK2
	BIT	LCBNK2
	JMP	CHK_KEYBD
NOBREAK:
.ENDIF
	PHP			; SAVE FLAGS
	SEI			; MAKE SURE NO REAL INTERRUPTS HAPPEN
	LDX	#$0F		; SAVE AND RESTORE ZP LIKE PRODOS
:	LDA	$F0,X
	STA	SAVEZPIRQ,X
	DEX
	BPL	:-
	JSR	IO_INTERRUPT
	LDX	#$0F
:	LDA	SAVEZPIRQ,X
	STA	$F0,X
	DEX
	BPL	:-
	PLP			; RESTORE FLAGS
	JMP	THREAD_YIELD
;
; FAKE A KEYBOARD IRQ.  HANDLE LIKE ANY OTHER IRQ
;
KEYBD_IRQ:	LDA	KEYBD
	BMI	TYPEAHEAD
	SEC
	RTS
TYPEAHEAD:	BIT	CLRKBD
	LDX	TYPEBUFFLEN
	CPX	#TYPEBUFFMAX
	BCS	:+
	AND	#$7F
	STA	TYPEBUFF,X
	INC	TYPEBUFFLEN
	RTS
:	LDA	#$07
	JSR	COUT
	CLC
	RTS	
;
; READ CHARACTER FROM KEYBOARD BUFFER, WAITING IF NONE AVAILABLE
; EXIT: A = CHARACTER
;
KEYBD_READ:	SEI
	LDX	TYPEBUFFLEN
	BNE	:+
	CLI
	LDY	CURRENT_THREAD
	JSR	THREAD_NOTIMEOUT
	LDY	#$03
	JSR	THREAD_WAITIO
	JMP	KEYBD_READ
:	LDY	TYPEBUFF		; SAVE OLDEST CHAR
	DEC	TYPEBUFFLEN
	BEQ	KEYBDEXIT
	LDX	#$00
:	LDA	TYPEBUFF+1,X		; SHIFT TYPE AHEAD BUFFER DOWN
	STA	TYPEBUFF,X
	INX
	CPX	TYPEBUFFLEN
	BNE	:-
KEYBDEXIT:	TYA
	CLI
	RTS
;*
;* PRODOS WRAPPERS
;*
;
; CALL PRODOS MLI
; ENTRY: AX = BYTE ARRAY REFERENCE FOR PARAM BLOCK
;         Y = PRODOS COMMAND
PRODOS_MLI:	STY	MLI_CMD
	JSR	HMEM_PTR
	CLC			; SKIP ARRAY LENGTH WORD
	ADC	#$02
	BCC	:+
	INX
:	STA	MLI_PARAMS
	STX	MLI_PARAMS+1
	BIT	ROMIN
	JSR	PRODOS
MLI_CMD:	.BYTE	$00
MLI_PARAMS:	.ADDR	$0000
	JMP	SETLCBNK2
;
; SET PREFIX
; ENTRY: AX = PREFIX STRING HANDLE
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
;PREFIX_SET:	JSR	HMEM_PTR
;	STA	PREFIXPARMS+1
;	STX	PREFIXPARMS+2
;	BIT	ROMIN
;	JSR	PRODOS
;	.BYTE	$C6
;	.ADDR	PREFIXPARMS
;	JMP	SETLCBNK2
;
; GET PREFIX
; ENTRY: AX = POINTER TO PREFIX STRING
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
PREFIX_GET:	STA	PREFIXPARMS+1
	STX	PREFIXPARMS+2
	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$C7
	.ADDR	PREFIXPARMS
	JMP	SETLCBNK2
;
; OPEN FILE
; ENTRY: AX = POINTER TO FILENAME
; EXIT:   C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
FILE_OPEN:	STA	OPENPARMS+1
	STX	OPENPARMS+2
	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDX	OPENPARMS+5
	STX	READPARMS+1
	STX	CLOSEPARMS+1
:	JMP	SETLCBNK2
;
; SET DATA BUFFER FOR FILE DATA.
; ENTRY: AX = DATA BUFFER POINTER
;
FILE_SETBUFFER:	STA	READPARMS+2
	STX	READPARMS+3
	CLC
	RTS
;
; CLOSE FILE
;
FILE_CLOSE:	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
	JMP	SETLCBNK2
;
; READ FROM FILE
; ENTRY: AX = NUMBER OF BYTES TO READ
; EXIT:  AX = NUMBER OF BYTES ACTUALLY READ
;         C = 0 :: SUCCESS
;         C = 1 :: FAILURE
;
FILE_READ:	STA	READPARMS+4
	STX	READPARMS+5
	BIT	ROMIN
	JSR	PRODOS
	.BYTE	$CA		; READ FILE
	.ADDR	READPARMS
	BCS	:+
	LDA	READPARMS+4
	LDX	READPARMS+5
:	JMP	SETLCBNK2
.IF	0
;
; READ BINARY FILE
; ENTRY: AX = POINTER TO FILE NAME/ADDRESS
;
BLOAD:	BIT	ROMIN
	STA	LDPTR
	STX	LDPTR+1
	CLC			; SET FILENAME BUFFER
	ADC	#$02
	STA	OPENPARMS+1
	TXA
	ADC	#$00
	STA	OPENPARMS+2
	LDY	#$00		; SET DATA ADDRESS
	LDA	(LDPTR),Y
	STA	READPARMS+2
	INY
	LDA	(LDPTR),Y
	STA	READPARMS+3
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDA	OPENPARMS+5
	STA	GETEOFPARMS+1
	STA	READPARMS+1
	STA	CLOSEPARMS+1
	JSR	PRODOS
	.BYTE	$D1		; GET EOF (FILE LEN)
	.ADDR	GETEOFPARMS
	BCS	:+
	LDA	GETEOFPARMS+2
	STA	READPARMS+4
	LDA	GETEOFPARMS+3
	STA	READPARMS+5
	JSR	PRODOS
	.BYTE	$CA		; READ FILE
	.ADDR	READPARMS
	BCS	:+
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
:	JMP	SETLCBNK2
;
; WRITE BINARY FILE
; ENTRY: AX = FILE NAME/ADDRESS/SIZE
;
BSAVE:	BIT	ROMIN
	STA	LDPTR
	STX	LDPTR+1
	CLC			; SET FILENAME BUFFER
	ADC	#$02
	STA	OPENPARMS+1
	TXA
	ADC	#$00
	STA	OPENPARMS+2
	LDY	#$00		; SET DATA ADDRESS
	LDA	(LDPTR),Y
	STA	WRITEPARMS+2
	INY
	LDA	(LDPTR),Y
	STA	WRITEPARMS+3
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDA	OPENPARMS+5
	STA	WRITEPARMS+1
	STA	CLOSEPARMS+1
	JSR	PRODOS
	.BYTE	$CA		; WRITE FILE
	.ADDR	WRITEPARMS
	BCS	:+
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
:	JMP	SETLCBNK2
.ENDIF	
	.DATA
IRQ_PROC:	.ADDR	$0000
TIMER_PROC:	.ADDR	$0000
IRQ_SLOT:	.BYTE	$00
IRQ_PROCL:	.BYTE	$00,$00,$00,$00,$00,$00,$00
IRQ_PROCH:	.BYTE	$00,$00,$00,$00,$00,$00,$00
PREFIXPARMS:	.BYTE	$01
	.ADDR	$0000		; PATH ADDR
OPENPARMS:	.BYTE	$03
	.ADDR	$0000		; PATH ADDR
	.ADDR	$0800		; BUFF ADDR
	.BYTE	$00		; REF NUM
GETEOFPARMS:	.BYTE	$02
	.BYTE	$00		; REF NUM
	.BYTE	$00,$00,$00		; EOF L/M/H
READPARMS:	
WRITEPARMS:	.BYTE	$04
	.BYTE	$00		; REF NUM
	.ADDR	$0000		; DATA ADDR
	.ADDR	$0000		; DATA LEN
	.ADDR	$0000		; ACTUAL LEN
CLOSEPARMS:	.BYTE	$01
	.BYTE	$00		; REF NUM
SAVEZPIRQ:	.RES	16		; SAVED ZERO PAGE LOCS FOR IRQ